<?php
// Klasa Database reprezentuje globalne połączenie z bazą danych
class Database extends PDO {
  // Zmienna statyczna do przechowywania jedynego egzemplarza klasy
  private static $_instance = null;
  
  // Zdefiniowanie konstruktora jako prywatnego, aby uniemożliwić tworzenie wielu obiektów
  private function __construct()
  {
    // Wywołanie konstruktora klasy PDO
    parent::__construct(APP_DB_DSN, APP_DB_USER, APP_DB_PASSWORD);
  }

  // Metoda dostępu do jedynego egzemplarza klasy
  public static function getInstance()
  {
    if (!(self::$_instance instanceof Database)) {
      self::$_instance = new Database();
    }
    
    return self::$_instance;
  }
}
?>